package edu.princeton.cs.lift.checkstyle;

import com.puppycrawl.tools.checkstyle.api.*;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;

import java.util.HashSet;
import java.util.Scanner;
import java.io.File;
import java.io.FileNotFoundException;

public class ProfanityCheck extends AbstractCheck {
    private static HashSet<String> blacklist = initializeBlacklist();


    /**
     * A key is pointing to the warning message text in "messages.properties"
     * file.
     */
    public static final String MSG_IDENT   = "profanity.identifier";
    public static final String MSG_COMMENT = "profanity.comment";
    public static final String MSG_STRING  = "profanity.string.literal";

    @Override
    public int[] getDefaultTokens() {
        return new int[] {TokenTypes.IDENT,
                          TokenTypes.COMMENT_CONTENT,
                          TokenTypes.STRING_LITERAL};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[] {TokenTypes.IDENT,
                          TokenTypes.COMMENT_CONTENT,
                          TokenTypes.STRING_LITERAL};
    }


    @Override
    public void visitToken(DetailAST ast) {

        // identifiers
        if (ast.getType() == TokenTypes.IDENT) {
            String word = ast.getText();
            if (isProfanity(word)) {
                reportStyleError(ast, word);
            }
        }

        // within comments
        else if (ast.getType() == TokenTypes.COMMENT_CONTENT) {
            String[] words = ast.getText().trim().split("\\s+");
            for (String word : words) {
                if (isProfanity(word)) {
                    reportStyleError(ast, word);
                }
            }
        }

        // within string literals (strip double quotes and consider each word)
        else if (ast.getType() == TokenTypes.STRING_LITERAL) {
            String text = ast.getText();
            text = text.substring(1, text.length() - 1);
            String[] words = text.trim().split("\\s+");
            for (String word : words) {
                if (isProfanity(word)) {
                    reportStyleError(ast, word);
                }
            }
        }
        
    }

    public boolean isCommentNodesRequired() {
        return true;
    }


    private boolean isProfanity(String word) {
        return blacklist.contains(word.toLowerCase());
    }


    private void reportStyleError(DetailAST ast, String profanity) {

        // identifiers
        if (ast.getType() == TokenTypes.IDENT) {
            log(ast.getLineNo(),
                ast.getColumnNo(),
                MSG_IDENT,
                profanity);
        }

        // within comments
        else if (ast.getType() == TokenTypes.COMMENT_CONTENT) {
            log(ast.getLineNo(),
                ast.getColumnNo(),
                MSG_COMMENT,
                profanity);
        }

        // within string literals (strip double quotes and consider each word)
        else if (ast.getType() == TokenTypes.STRING_LITERAL) {
            log(ast.getLineNo(),
                ast.getColumnNo(),
                MSG_STRING,
                profanity);
        }

        else throw new IllegalStateException("neither a class variable nor an instance variable");

    }


/*
    // read blacklisted words from a file
    private static HashSet<String> initializeBlacklist() {
        HashSet<String> blacklist = new HashSet<String>();
        File file = new File("profanity.txt");
        try {
            Scanner scanner = new Scanner(file);
            while (scanner.hasNext()) {
                String word = scanner.next();
                blacklist.add(word);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
        }
        return blacklist;
    }
*/

    // read blacklisted words from Java string
    private static HashSet<String> initializeBlacklist() {
        HashSet<String> blacklist = new HashSet<String>();

        String[] words = {
            "a55",
            "a55hole",
            "abbo",
            "abo",
            "aeolus",
            "ahole",
            "alligatorbait",
            "analannie",
            "analprobe",
            "analsex",
            "anilingus",
            "arse",
            "arsehole",
            "ass",
            "assbagger",
            "assbang",
            "assbanged",
            "assbangs",
            "assblaster",
            "assclown",
            "asscowboy",
            "asses",
            "assfuck",
            "assfucker",
            "assh0le",
            "asshat",
            "assho1e",
            "asshole",
            "assholes",
            "asshore",
            "assjockey",
            "asskiss",
            "asskisser",
            "assklown",
            "asslick",
            "asslicker",
            "asslover",
            "assman",
            "assmaster",
            "assmonkey",
            "assmunch",
            "assmuncher",
            "asspacker",
            "asspirate",
            "asspuppies",
            "assranger",
            "asswhore",
            "asswipe",
            "asswipes",
            "athletesfoot",
            "azazel",
            "azz",
            "b1tch",
            "backdoorman",
            "badfuck",
            "balllicker",
            "ballsack",
            "barelylegal",
            "bastard",
            "bastards",
            "bawdy",
            "bazongas",
            "bazooms",
            "beardedclam",
            "beatoff",
            "beat-off",
            "beatyourmeat",
            "beaver",
            "beeyotch",
            "beotch",
            "biatch",
            "bicurious",
            "bigass",
            "bigbastard",
            "bigbutt",
            "bigtits",
            "bimbo",
            "bitch",
            "bitched",
            "bitcher",
            "bitches",
            "bitchez",
            "bitchin",
            "bitching",
            "bitchslap",
            "bitchy",
            "biteme",
            "blackman",
            "blowjob",
            "blowjobs",
            "boang",
            "bohunk",
            "boink",
            "bollick",
            "bollock",
            "bollocks",
            "bollok",
            "boner",
            "boners",
            "boob",
            "boobies",
            "boobs",
            "booby",
            "boody",
            "boong",
            "boonga",
            "boonie",
            "bootee",
            "bootie",
            "booty",
            "bootycall",
            "bosom",
            "bosomy",
            "bountybar",
            "breastjob",
            "breastlover",
            "breastman",
            "bukkake",
            "bullcrap",
            "bulldike",
            "bulldyke",
            "bullshit",
            "bullshits",
            "bullshitted",
            "bullturds",
            "bumblefuck",
            "bumfuck",
            "bung",
            "bunga",
            "bunghole",
            "butchbabes",
            "butchdike",
            "butchdyke",
            "butt",
            "buttbang",
            "butt-bang",
            "buttface",
            "buttfuck",
            "butt-fuck",
            "buttfucker",
            "butt-fucker",
            "buttfuckers",
            "butt-fuckers",
            "butthead",
            "buttman",
            "buttmunch",
            "buttmuncher",
            "buttpirate",
            "buttplug",
            "buttstain",
            "byatch",
            "c0ck",
            "c-0-c-k",
            "c.0.c.k",
            "caca",
            "cacker",
            "cahone",
            "cameljockey",
            "cameltoe",
            "carpetmuncher",
            "carruth",
            "cawk",
            "chav",
            "cherrypopper",
            "chickslick",
            "chinaman",
            "chinamen",
            "chinc",
            "chincs",
            "chink",
            "chinky",
            "choad",
            "chode",
            "chodes",
            "cl1t",
            "clamdigger",
            "clamdiver",
            "clit",
            "clitoris",
            "clitorus",
            "clits",
            "clitty",
            "clogwog",
            "cock",
            "c-o-c-k",
            "c.o.c.k.",
            "cockblock",
            "cockblocker",
            "cockcowboy",
            "cockfight",
            "cockhead",
            "cockholster",
            "cockknob",
            "cockknocker",
            "cocklicker",
            "cocklover",
            "cocknob",
            "cockqueen",
            "cockrider",
            "cocks",
            "cocksman",
            "cocksmith",
            "cocksmoker",
            "cocksucer",
            "cocksuck",
            "cocksucked",
            "cocksucker",
            "cocksucking",
            "cocktail",
            "cocktease",
            "cocky",
            "cohee",
            "coital",
            "coitus",
            "coon",
            "coondog",
            "coons",
            "corksucker",
            "cornhole",
            "corruption",
            "cra5h",
            "crackpipe",
            "crackwhore",
            "crack-whore",
            "crotch",
            "crotchjockey",
            "crotchmonkey",
            "crotchrot",
            "cum",
            "cumbubble",
            "cumfest",
            "cumjockey",
            "cumm",
            "cummer",
            "cummin",
            "cumming",
            "cumquat",
            "cumqueen",
            "cumshot",
            "cumshots",
            "cumslut",
            "cumstain",
            "cunilingus",
            "cunillingus",
            "cunn",
            "cunnilingus",
            "cunntt",
            "cunny",
            "cunt",
            "c-u-n-t",
            "c.u.n.t",
            "cunteyed",
            "cuntface",
            "cuntfuck",
            "cuntfucker",
            "cunthunter",
            "cuntlick",
            "cuntlicker",
            "cuntlicking",
            "cunts",
            "cuntsucker",
            "cybersex",
            "cyberslimer",
            "d0ng",
            "d0uch3",
            "d0uche",
            "d1ck",
            "d1ld0",
            "d1ldo",
            "dago",
            "dagos",
            "dammit",
            "damned",
            "damnit",
            "darkie",
            "darky",
            "datnigga",
            "dawgie-style",
            "deapthroat",
            "deepthroat",
            "defecate",
            "dego",
            "devilworshipper",
            "dickbag",
            "dickbrain",
            "dickdipper",
            "dickface",
            "dickflipper",
            "dickforbrains",
            "dickhead",
            "dickheads",
            "dickish",
            "dick-ish",
            "dickless",
            "dicklick",
            "dicklicker",
            "dickman",
            "dickripper",
            "dicksipper",
            "dickwad",
            "dickweed",
            "dickwhipper",
            "dickzipper",
            "diddle",
            "dike",
            "diligaf",
            "dillweed",
            "dingle",
            "dingleberry",
            "dipship",
            "dipshit",
            "dipstick",
            "dixiedike",
            "dixiedyke",
            "doggiestyle",
            "doggie-style",
            "doggystyle",
            "doggy-style",
            "doosh",
            "douch3",
            "douche",
            "douchebag",
            "douchebags",
            "douchey",
            "dragqueen",
            "dragqween",
            "dripdick",
            "dumass",
            "dumbass",
            "dumbasses",
            "dumbbitch",
            "dumbfuck",
            "dyefly",
            "dyke",
            "dykes",
            "easyslut",
            "eatballs",
            "eatme",
            "eatpussy",
            "essohbee",
            "facefucker",
            "fack",
            "faeces",
            "fag",
            "fagg",
            "fagged",
            "fagging",
            "faggit",
            "faggot",
            "fagot",
            "fags",
            "faig",
            "faigt",
            "fannybandit",
            "fannyfucker",
            "fastfuck",
            "fatah",
            "fatass",
            "fatfuck",
            "fatfucker",
            "fatso",
            "fckcum",
            "feces",
            "felatio",
            "felch",
            "felcher",
            "felching",
            "fellate",
            "fellatio",
            "feltch",
            "feltcher",
            "feltching",
            "fingerfood",
            "fingerfuck",
            "fingerfucked",
            "fingerfucker",
            "fingerfuckers",
            "fingerfucking",
            "fistfuck",
            "fistfucked",
            "fistfucker",
            "fistfucking",
            "fisting",
            "flange",
            "floozy",
            "flydie",
            "flydye",
            "foad",
            "fok",
            "footaction",
            "footfuck",
            "footfucker",
            "footlicker",
            "footstar",
            "foreskin",
            "fourtwenty",
            "freakfuck",
            "freakyfucker",
            "freefuck",
            "freex",
            "frigg",
            "frigga",
            "fubar",
            "fuc",
            "fucck",
            "fuck",
            "f-u-c-k",
            "f.u.c.k",
            "fucka",
            "fuckable",
            "fuckass",
            "fuckbag",
            "fuckbuddy",
            "fucked",
            "fuckedup",
            "fucker",
            "fuckers",
            "fuckface",
            "fuckfest",
            "fuckfreak",
            "fuckfriend",
            "fuckhead",
            "fuckher",
            "fuckin",
            "fuckina",
            "fucking",
            "fuckingbitch",
            "fuckinnuts",
            "fuckinright",
            "fuckit",
            "fuckknob",
            "fuckme",
            "fuckmehard",
            "fuckmonkey",
            "fucknugget",
            "fucknut",
            "fuckoff",
            "fuckpig",
            "fucks",
            "fucktard",
            "fuck-tard",
            "fuckup",
            "fuckwad",
            "fuckwhore",
            "fuckwit",
            "fuckyou",
            "fudgepacker",
            "fugly",
            "fuk",
            "fuks",
            "funfuck",
            "fuuck",
            "fvck",
            "fxck",
            "gangbang",
            "gangbanged",
            "gangbanger",
            "gangsta",
            "ganja",
            "gatorbait",
            "gaymuthafuckinwhore",
            "gaysex",
            "geezer",
            "genital",
            "getiton",
            "gigolo",
            "ginzo",
            "gipp",
            "givehead",
            "glazeddonut",
            "goatse",
            "godammit",
            "godamn",
            "godamnit",
            "goddam",
            "goddamit",
            "goddammit",
            "goddamn",
            "goddamned",
            "goddamnes",
            "goddamnit",
            "goddamnmuthafucker",
            "goldenshower",
            "gonorrehea",
            "gonzagas",
            "gook",
            "gooks",
            "gotohell",
            "goy",
            "goyim",
            "greaseball",
            "gringo",
            "grostulation",
            "gspot",
            "g-spot",
            "gtfo",
            "gubba",
            "guido",
            "gummer",
            "gyp",
            "gypo",
            "gypp",
            "gyppie",
            "gyppo",
            "gyppy",
            "h0m0",
            "h0mo",
            "handjob",
            "hapa",
            "hardon",
            "harem",
            "he11",
            "headfuck",
            "hebe",
            "heeb",
            "hell",
            "hillbillies",
            "hindoo",
            "hiscock",
            "hobag",
            "hobo",
            "hodgie",
            "holestuffer",
            "hom0",
            "homey",
            "homo",
            "homobangers",
            "homoey",
            "honger",
            "honk",
            "honkers",
            "honkey",
            "honky",
            "hooch",
            "hookah",
            "hooker",
            "hookers",
            "hoor",
            "hootch",
            "hooter",
            "hooters",
            "hore",
            "hork",
            "horney",
            "horniest",
            "horny",
            "horseshit",
            "hosejob",
            "hoser",
            "hotdamn",
            "hotpussy",
            "hottotrot",
            "hussy",
            "hymen",
            "hymie",
            "iblowu",
            "ikey",
            "injun",
            "intercourse",
            "interracial",
            "intheass",
            "inthebuff",
            "italiano",
            "j3rk0ff",
            "jackass",
            "jackhole",
            "jackoff",
            "jackshit",
            "jacktheripper",
            "jap",
            "japcrap",
            "japs",
            "jebus",
            "jeez",
            "jerk",
            "jerk0ff",
            "jerked",
            "jerkoff",
            "jesuschrist",
            "jiga",
            "jigaboo",
            "jigg",
            "jigga",
            "jiggabo",
            "jigger",
            "jiggy",
            "jijjiboo",
            "jimfish",
            "jism",
            "jiz",
            "jizim",
            "jizjuice",
            "jizm",
            "jizz",
            "jizzed",
            "jizzim",
            "jizzum",
            "juggalo",
            "jugs",
            "junglebunny",
            "kaffer",
            "kaffir",
            "kaffre",
            "kafir",
            "kanake",
            "kigger",
            "kike",
            "kikes",
            "kissass",
            "knobend",
            "knockers",
            "kock",
            "kondum",
            "kooch",
            "kooches",
            "koon",
            "kootch",
            "kotex",
            "krap",
            "krappy",
            "kraut",
            "kum",
            "kumbubble",
            "kumbullbe",
            "kummer",
            "kumming",
            "kumquat",
            "kums",
            "kunilingus",
            "kunnilingus",
            "kunt",
            "kyke",
            "lech",
            "leper",
            "lesbayn",
            "lesbin",
            "lesbo",
            "lesbos",
            "lez",
            "lezbe",
            "lezbefriends",
            "lezbian",
            "lezbians",
            "lezbo",
            "lezbos",
            "lezz",
            "lezzie",
            "lezzies",
            "lezzo",
            "lezzy",
            "licker",
            "lickme",
            "limey",
            "limpdick",
            "limy",
            "livesex",
            "lmfao",
            "lolita",
            "lovebone",
            "lovegoo",
            "lovegun",
            "lovejuice",
            "lovemuscle",
            "lovepistol",
            "loverocket",
            "lowlife",
            "luckycammeltoe",
            "lugan",
            "lusty",
            "macaca",
            "mams",
            "manhater",
            "manpaste",
            "massa",
            "mastabate",
            "mastabater",
            "masterblaster",
            "mastrabator",
            "masturbate",
            "mattressprincess",
            "meatbeatter",
            "meatrack",
            "m-fucking",
            "mgger",
            "mggor",
            "mickeyfinn",
            "milf",
            "mockey",
            "mockie",
            "mocky",
            "mofo",
            "moky",
            "moolie",
            "mooncricket",
            "mosshead",
            "mothafuck",
            "mothafucka",
            "mothafuckaz",
            "mothafucked",
            "mothafucker",
            "mothafuckin",
            "mothafucking",
            "mothafuckings",
            "motherfuck",
            "motherfucka",
            "motherfucked",
            "motherfucker",
            "motherfuckin",
            "motherfucking",
            "motherfuckings",
            "motherlovebone",
            "mtherfucker",
            "mthrfucker",
            "mthrfucking",
            "muff",
            "muffdive",
            "muffdiver",
            "muffindiver",
            "mufflikcer",
            "mulatto",
            "muncher",
            "munt",
            "muthafuckaz",
            "muthafucker",
            "mutherfucker",
            "mutherfucking",
            "muthrfucking",
            "nad",
            "nads",
            "nappy",
            "nastybitch",
            "nastyho",
            "nastyslut",
            "nastywhore",
            "necro",
            "negro",
            "negroes",
            "negroid",
            "negro's",
            "nig",
            "niger",
            "nigg",
            "nigga",
            "niggah",
            "niggaracci",
            "niggard",
            "niggarded",
            "niggarding",
            "niggardliness",
            "niggardliness's",
            "niggardly",
            "niggards",
            "niggard's",
            "niggas",
            "niggaz",
            "nigger",
            "niggerhead",
            "niggerhole",
            "niggers",
            "nigger's",
            "niggle",
            "niggled",
            "niggles",
            "niggling",
            "nigglings",
            "niggor",
            "niggur",
            "niglet",
            "nignog",
            "nigr",
            "nigra",
            "nigre",
            "nimrod",
            "ninny",
            "nip",
            "nipple",
            "nipplering",
            "nittit",
            "nlgger",
            "nlggor",
            "nofuckingway",
            "nutfucker",
            "ontherag",
            "orga",
            "organ",
            "orgasim",
            "orgasm",
            "orgasmic",
            "paddy",
            "paki",
            "palesimian",
            "pansies",
            "pansy",
            "pastie",
            "pasty",
            "pearlnecklace",
            "pecker",
            "peckerwood",
            "peehole",
            "peepshow",
            "peepshpw",
            "peni5",
            "penial",
            "penile",
            "penis",
            "penises",
            "perv",
            "peyote",
            "phalli",
            "phallic",
            "phonesex",
            "phuck",
            "phuk",
            "phuked",
            "phuking",
            "phukked",
            "phukking",
            "phungky",
            "phuq",
            "pi55",
            "picaninny",
            "piccaninny",
            "pickaninny",
            "piker",
            "pikey",
            "piky",
            "pillowbiter",
            "pimped",
            "pimper",
            "pimpjuic",
            "pimpjuice",
            "pimpsimp",
            "pindick",
            "pinko",
            "pisshead",
            "pocha",
            "pocho",
            "pocketpool",
            "pohm",
            "pommie",
            "pommy",
            "poon",
            "poontang",
            "pooperscooper",
            "poorwhitetrash",
            "popimp",
            "porchmonkey",
            "pornprincess",
            "pric",
            "prick",
            "prickhead",
            "prig",
            "pu55i",
            "pu55y",
            "pube",
            "pubic",
            "pubiclice",
            "pubis",
            "punkass",
            "puntang",
            "purinapricness",
            "puss",
            "pussie",
            "pussies",
            "pussy",
            "p.u.s.s.y.",
            "pussycat",
            "pussyeater",
            "pussyfucker",
            "pussylicker",
            "pussylips",
            "pussylover",
            "pussypounder",
            "pusy",
            "puto",
            "quashie",
            "queero",
            "quickie",
            "quicky",
            "quim",
            "ra8s",
            "raghead",
            "rape",
            "raped",
            "raper",
            "rapist",
            "raunch",
            "rearend",
            "rearentry",
            "reefer",
            "reestie",
            "reetard",
            "rentafuck",
            "retard",
            "retarded",
            "revue",
            "ribbed",
            "rigger",
            "rimjob",
            "rimming",
            "ritard",
            "roundeye",
            "rtard",
            "r-tard",
            "rump",
            "rumprammer",
            "ruski",
            "russki",
            "russkie",
            "s0b",
            "sadis",
            "sadom",
            "samckdaddy",
            "sandm",
            "sandnigger",
            "scag",
            "scallywag",
            "scat",
            "schizo",
            "schlong",
            "screwyou",
            "scrog",
            "scrot",
            "scrote",
            "scrotum",
            "scrud",
            "seaman",
            "seamen",
            "semen",
            "seppo",
            "sexed",
            "sexfarm",
            "sexhound",
            "sexhouse",
            "sexing",
            "sexkitten",
            "sexpot",
            "sexslave",
            "sextogo",
            "sextoy",
            "sextoys",
            "sexwhore",
            "sexymoma",
            "sexy-slim",
            "sh1t",
            "s-h-1-t",
            "shag",
            "shaggin",
            "shagging",
            "shamedame",
            "shat",
            "shav",
            "shawtypimp",
            "sheeney",
            "shhit",
            "shinola",
            "shit",
            "s-h-i-t",
            "s.h.i.t.",
            "shitcan",
            "shitdick",
            "shite",
            "shiteater",
            "shited",
            "shitface",
            "shitfaced",
            "shitfit",
            "shitforbrains",
            "shitfuck",
            "shitfucker",
            "shitfull",
            "shithapens",
            "shithappens",
            "shithead",
            "shithole",
            "shithouse",
            "shiting",
            "shitlist",
            "shitola",
            "shitoutofluck",
            "shits",
            "shitstain",
            "shitt",
            "shitted",
            "shitter",
            "shitting",
            "shitty",
            "shiz",
            "shortfuck",
            "sissy",
            "sixsixsix",
            "sixtynine",
            "sixtyniner",
            "skag",
            "skank",
            "skankbitch",
            "skankfuck",
            "skankwhore",
            "skanky",
            "skankybitch",
            "skankywhore",
            "skinflute",
            "skum",
            "skumbag",
            "slanteye",
            "slapper",
            "slideitin",
            "slopehead",
            "slutdumper",
            "slutkiss",
            "slutwhore",
            "smackthemonkey",
            "smegma",
            "snatchpatch",
            "snigger",
            "sniggered",
            "sniggering",
            "sniggers",
            "snigger's",
            "sniper",
            "snowback",
            "snownigger",
            "snuff",
            "sob",
            "s-o-b",
            "s.o.b.",
            "sodom",
            "sodomise",
            "sodomite",
            "sodomize",
            "sodomy",
            "sonofabitch",
            "sonofbitch",
            "sooty",
            "souse",
            "soused",
            "spaghettibender",
            "spaghettinigger",
            "spankthemonkey",
            "spermbag",
            "spermhearder",
            "spermherder",
            "spic",
            "spick",
            "spig",
            "spigotty",
            "spik",
            "spiks",
            "splittail",
            "spooge",
            "spreadeagle",
            "spunk",
            "spunky",
            "squaw",
            "stagg",
            "stfu",
            "stiffy",
            "strapon",
            "stringer",
            "stripclub",
            "stupid",
            "stupidfuck",
            "stupidfucker",
            "suckdick",
            "suckme",
            "suckmyass",
            "suckmydick",
            "suckmytit",
            "suckoff",
            "sumofabiatch",
            "swallower",
            "t1t",
            "taff",
            "tantra",
            "tarbaby",
            "tard",
            "teabagging",
            "teat",
            "teste",
            "testee",
            "testes",
            "testicle",
            "testicles",
            "testis",
            "thicklips",
            "thirdeye",
            "thirdleg",
            "timbernigger",
            "tinkle",
            "tit",
            "titbitnipply",
            "titfuck",
            "titfucker",
            "titfuckin",
            "titi",
            "titjob",
            "titlicker",
            "titlover",
            "tits",
            "tittie",
            "tittiefucker",
            "titties",
            "titty",
            "tittyfuck",
            "tittyfucker",
            "toke",
            "tongethruster",
            "tonguethrust",
            "tonguetramp",
            "toots",
            "tosser",
            "towelhead",
            "trailertrash",
            "tramp",
            "trannie",
            "tranny",
            "transvestite",
            "triplex",
            "trots",
            "tubgirl",
            "tuckahoe",
            "tunneloflove",
            "twink",
            "twinkie",
            "twobitwhore",
            "unfuckable",
            "upskirt",
            "uptheass",
            "upthebutt",
            "vag",
            "vagina",
            "vaginal",
            "viagra",
            "vibr",
            "vibrater",
            "vibrator",
            "vietcong",
            "virginbreaker",
            "vixen",
            "vulva",
            "wab",
            "wad",
            "wank",
            "wanker",
            "wanking",
            "waysted",
            "wazoo",
            "weenie",
            "weewee",
            "weiner",
            "weirdo",
            "welcher",
            "wench",
            "wetb",
            "wetback",
            "wetspot",
            "wh0re",
            "wh0reface",
            "whacker",
            "whash",
            "whigger",
            "whiskeydick",
            "whiskydick",
            "whit",
            "whitenigger",
            "whitetrash",
            "whitey",
            "whiz",
            "whop",
            "whoralicious",
            "whore",
            "whorealicious",
            "whored",
            "whoreface",
            "whorefucker",
            "whorehopper",
            "whorehouse",
            "whores",
            "whoring",
            "wigger",
            "williewanker",
            "willy",
            "wog",
            "wuss",
            "wuzzie",
            "yeasty",
            "yellowman",
            "yobbo",
            "zigabo",
            "zipperhead",
            "zoophile",
        };

        for (String word : words) {
            blacklist.add(word);
        }
        return blacklist;
    }
}
