// all instance variables of outer class are immutable

package edu.princeton.cs.lift.checkstyle;

import com.puppycrawl.tools.checkstyle.api.*;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import java.util.ArrayList;

public class ImmutableTypeCheck extends AbstractCheck {

    public static final String MSG_INSTANCE_VARIABLE = "immutable.nonfinal.instance.variable";
    public static final String MSG_STATIC_VARIABLE   = "immutable.nonfinal.static.variable";

    @Override
    public int[] getDefaultTokens() {
        return new int[] {TokenTypes.VARIABLE_DEF};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[] {TokenTypes.VARIABLE_DEF};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[] {TokenTypes.VARIABLE_DEF};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (Utilities.isInOuterMostClass(ast) && Utilities.isInstanceVariable(ast) && !Utilities.isFinalInstanceVariable(ast)) {
            String variableName = findVariableName(ast);
            log(ast.getLineNo(),
                MSG_INSTANCE_VARIABLE,
                variableName);
        }

        else if (Utilities.isInOuterMostClass(ast) && Utilities.isStaticVariable(ast) && !Utilities.isStaticFinalVariable(ast)) {
            String variableName = findVariableName(ast);
            log(ast.getLineNo(),
                MSG_STATIC_VARIABLE,
                variableName);
        }

    }


    // extract and return the variable name from the AST
    private String findVariableName(DetailAST ast) {
        DetailAST identifier = ast.findFirstToken(TokenTypes.IDENT);
        return identifier.getText();
    }

}
