public class PairStar {
    /**
     * Given a string, compute recursively a new string where identical chars that are adjacent in
     * the original string are separated from each other by a "*".
     * <p>
     * pairStar("hello") → "hel*lo"
     * pairStar("xxyy") → "x*xy*y"
     * pairStar("aaaa") → "a*a*a*a"
     */
    public static String pairStar(String str) {
        if (str.length() < 2) {
            return str;
        }
        else {
            int split = str.length() / 2;
            String join = "";
            if (str.charAt(split - 1) == str.charAt(split)) {
                join = "*";
            }
            return pairStar(str.substring(0, split - 1)) + join + pairStar(
                    str.substring(split));
        }
    }

    public static void main(String[] args) {
        StdOut.println(pairStar(args[0]));
    }
}
