public class Turtle {
    private double x = 0.0;
    private double y = 0.0;
    private double direction = 0.0;

    public String getCoordinates() {
        return String.format("(%.2f, %.2f)", x, y);
    }

    public void turn(double angle) {
        direction += angle;
    }

    public void move(double distance) {
        x += Math.cos(direction) * distance;
        y += Math.cos(direction) * distance;
    }

    public static void main(String[] args) {
        Turtle t = new Turtle();
        StdOut.println("Initial coordinates: " + t.getCoordinates());
        StdOut.print("Turn how many degrees? ");
        while (!StdIn.isEmpty()) {
            t.turn(StdIn.readDouble());
            StdOut.print("Move how far? ");
            t.move(StdIn.readDouble());
            StdOut.println("Updated coordinates: " + t.getCoordinates());
            StdOut.print("Turn how many degrees? ");
        }
    }
}
