import java.awt.Image;
import java.awt.Color;

/***********
 * The VideoSink class represents the entry point for high level
 * analysis of videos.  The videoSink has the ability to display 
 * images with the ImageViewer class.
 * 
 * @author Sam Epstein
 **********/
public class ImageProcessor {

	//The window to display images
	ImageViewer imageViewer;
	
	//Simple counter for video cutoff
	long counter;
	
	//The constructor initializes the window for display
	ImageProcessor()
	{
		imageViewer=new ImageViewer("Image Viewer");
		counter = 0;
	}
	
	
	 
	/**
	 * The central function of VideoSink and the place where students
	 * can edit the code. receiveFrame function is given an image. The 
	 * body of the code will perform high level manipulatations of the 
	 * image, then display the image in the imageViewer. The return values
	 * indicates to the the video source whether or not to keep sending 
	 * images.
	 * 
	 * @param frame The current frame of the video source/
	 * @param firstFrame Whether or not the frame is the first frame of the video
	 * @return true if the video source should continue, or false if the video source should stop.
	 */
	public boolean receiveFrame(SimpleImage frame) {
	
		/**********
		 * Replace function with your code
		 **********/

		//this code block puts a small red rectangle in the upper left corner of the image
		int x=0;
		int y=0;
		Color c;
		if(imageViewer.getKey()=='r')
		{
			c = new Color(255,0,0);
		}
		else if(imageViewer.getKey()=='g')
		{
			c = new Color(0,255,0);
		}
		else if(imageViewer.getKey()=='b')
		{
			c = new Color(0,0,255);
		}
		else
		{
			c = new Color(0,0,0);
		}
		
		// This code draws a square 20x20 pixels in the top left corner
		for(x=0; x<20; x++)
		{
			for(y=0; y<20; y++)
			{
				frame.set(x,y,c);
			}
		}
		
		
		boolean shouldStop = displayImage(frame); 
		return 	shouldStop;
	}

	/**
	 * This function displays the passed image in a frame.
	 * @param image The image to be displayed
	 */
	public boolean displayImage(SimpleImage image)
	{
		if(imageViewer == null || !imageViewer.isActive())
			return false;
		imageViewer.showImage(image);
		return true;
	}
	
	/***
	 * Closes the window
	 */
	public void close()
	{
		if(imageViewer!=null)
		{
			this.imageViewer.dispose();
			imageViewer=null;
		}
	}

}
